#include "main.h"

// Include the generated source index.
// NOTE: Keep the project name and this path in sync.
#include "Generated/Simple Serialization/Generated.ocppindex"
#include <fstream>

using namespace std;

// Entry point into the application.
int main()
{
	Cactus cactus(2000, 40.0);

	// Add some owls.
	cactus.AddOwl( Owl(1, 10.5, 49.6, 2.4) );
	cactus.AddOwl( Owl(2, 4.6, 22.9, 1.0) );

	// Text serialization.
	{
		// Save the cactus.
		{
			ofstream                            fout( "Cactus.txt" );
			opcpp::visitors::text_save_archiver save( fout );

			save << cactus;
		}

		// Load the cactus.
		{
			Cactus   newCactus;
			ifstream fin( "Cactus.txt" );
			opcpp::visitors::text_load_archiver load( fin );

			load >> newCactus;
		}
	}

	// Binary serialization.
	{
		// Save the cactus.
		{
			ofstream                              fout( "Cactus.bin", ios::binary );
			opcpp::visitors::binary_save_archiver save( fout );

			save << cactus;
		}

		// Load the cactus.
		{
			Cactus   newCactus;
			ifstream fin( "Cactus.bin", ios::binary );
			opcpp::visitors::binary_load_archiver load( fin );

			load >> newCactus;
		}
	}

	// Xml serialization.
	{
		// Save the cactus.
		{
			ofstream                           fout( "Cactus.xml" );
			opcpp::visitors::xml_save_archiver save( fout, "Root" );

			save.save( cactus, "Cactus" );

			vector<int> ints;

			for (int i = 0; i < 10; i++)
				ints.push_back( i );

			save.save( ints, "Ints" );
		}

		// Load the cactus.
		{
			Cactus   newCactus;
			ifstream fin( "Cactus.xml" );
			opcpp::visitors::xml_load_archiver load( fin, "Root" );

			// Check for an error.
			if ( load.Error() )
			{
				int    row         = load.ErrorRow();
				int    col         = load.ErrorCol();
				string description = load.ErrorDescription();

				// do something here ..
			}

			load.load( newCactus, "Cactus" );

			vector<int> ints;

			load.load( ints, "Ints" );
		}
	}

	return 0;
}